<?php

namespace App\Project;

use Illuminate\Database\Eloquent\Model;

class Project extends Model 
{

    protected $table = 'Project';
    public $timestamps = true;

    public function projectType()
    {
        return $this->hasOne('ProjectType', 'id');
    }

    public function members()
    {
        return $this->hasMany('Member');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function projectSetting()
    {
        return $this->hasOne('ProjectSetting');
    }

    public function tasks()
    {
        return $this->hasMany('Task');
    }

}